<?php
header("Content-Type: application/json");
include 'db_config.php';

// Get input data
$data = json_decode(file_get_contents("php://input"), true);

// Extract data from JSON input
$id = $data['Cus_Id'];
$Loan_Code = $data['Loan_Code']; // Loan Code (tblcusnewloandetail table code)
$Loan_Type = $data['Loan_Type']; // Individual or Group
$Rec_Date = $data['Rec_Date']; // Receipt date
$Pay_amount = $data['Pay_amount']; // Receipt amount
$states = $data['States'];
$paydays = $data['paydays']; // Before the payment
$Pay_days = $data['Pay_days']; // Receipt-covered installment
$LStates = $data['LStates'];

// Begin transaction
$conn->begin_transaction();

try {
	if (empty($Loan_Type)) {
    throw new Exception("Error: Rec_Date is missing or invalid.");
	}
	if (empty($Rec_Date)) {
    throw new Exception("Error: Rec_Date is missing or invalid.");
}
    // SQL query: Insert into `tblreceipts`
    $sql = "INSERT INTO `tblreceipts` 
            (`Cus_Id`, `Loan_Code`, `Loan_Type`, `Pay_Date`, `Pay_amount`, `Status`, `LastUpdate_Date`, `LastUpdate_time`, `installment_from`, `installment_to`) 
            VALUES (?, ?, ?, ?, ?, ?, CURRENT_DATE, CURRENT_TIME, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
	$Rec_Date = date('Y-m-d', strtotime($data['Rec_Date']));
    $installment_from = $paydays + 1; // Calculate installment_from
	$sPay_days = $Pay_days + $paydays;
    $stmt->bind_param("sissdsii", $id, $Loan_Code, $Loan_Type, $Rec_Date, $Pay_amount, $states, $installment_from, $sPay_days);
    $stmt->execute();

    // SQL query: Update `tblcusnewloandetail`
    $sq2 = "UPDATE `tblgroupnewloan` 
            SET `BalAmount` = `BalAmount` - ?, 
                `PayAmount` = `PayAmount` + ?, 
                `Pay_days` = Pay_days + ?, 
				`States` = ?
            WHERE `Code` = ?";
			
			
    
    $stmt2 = $conn->prepare($sq2);
    if (!$stmt2) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt2->bind_param("ddiss", $Pay_amount, $Pay_amount, $Pay_days,$LStates $Loan_Code);
    $stmt2->execute();

    // Commit transaction
    $conn->commit();

    echo json_encode(["status" => "success", "message" => "Data processed successfully"]);
} catch (Exception $e) {
    // Rollback on error
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
// Close the connection
$conn->close();
?>
