<?php
header('Content-Type: application/json');
include 'db_config.php';

// Check connection
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Database connection failed"]));
}

// Validate the Id parameter
$Id = isset($_GET['Id']) ? intval($_GET['Id']) : null;
if (!$Id || $Id <= 0) {
    echo json_encode(["status" => "error", "message" => "Invalid or missing Id parameter"]);
    exit;
}

// Prepare and execute the query
$sql = "SELECT r.`Code`, r.`installment_from`, r.`Loan_Code`, r.`Pay_amount`
    FROM `tblreceipts` r
    WHERE r.`Code` = (
        SELECT MAX(r2.`Code`) 
        FROM `tblreceipts` r2 
        WHERE r2.`Cus_Id` = ? AND r2.`Status` = 'A' AND r2.`Loan_Type` = 'I'
    )
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Query preparation failed"]);
    exit;
}

$stmt->bind_param("i", $Id);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = [
		  "Code" => $row["Code"],
            "installment_from" => $row["installment_from"],
            "Loan_Code" => $row["Loan_Code"],
            "Pay_amount" => $row["Pay_amount"],
        ];
    }
}

// Output the response
$response = [
    "status" => "success",
    "data" => $data
];
echo json_encode($response);

// Close connection
$stmt->close();

?>
