<?php 
header("Content-Type: application/json");

include 'db_config.php'; 

// Check connection
if ($conn->connect_error) {
    die(json_encode(["message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $CusName = isset($_POST['name']) ? $_POST['name'] : null;
    $tel = isset($_POST['telno']) ? $_POST['telno'] : null;
    $add = isset($_POST['address']) ? $_POST['address'] : null;
    $add1 = isset($_POST['address1']) ? $_POST['address1'] : null;
    $add2 = isset($_POST['address2']) ? $_POST['address2'] : null;

    if ($id && $CusName) {
        // Corrected bind_param to match the number of parameters
        $sql = "INSERT INTO tblcoustomer(`Customer`, `TelNo`, `address`, `address1`, `address2`, `id`) 
                VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        // Using "ssssss" for string parameters
        $stmt->bind_param("ssssss", $CusName, $tel, $add, $add1, $add2, $id);

        if ($stmt->execute()) {
            echo json_encode(["message" => "New record created successfully"]);
        } else {
            echo json_encode(["message" => "Error: " . $stmt->error]);
        }
    } else {
        echo json_encode(["message" => "Missing parameters"]);
    }
}

$conn->close();
?>
