<?php
include 'db_config.php'; // Include database configuration

// Check if the 'id' parameter is passed in the GET request
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // SQL query to delete the record with the given ID
    $sql = "DELETE FROM tblcoustomer WHERE id = ?";
    
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $id); // "i" means integer
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            echo "Record deleted successfully.";
        } else {
            echo "No record found with the given ID.";
        }
        
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $conn->error;
    }

    // Close the database connection
    $conn->close();
} else {
    echo "ID parameter is missing.";
}
?>
,