<?php
header('Content-Type: application/json');
include 'db_config.php';

// Check connection
if ($conn->connect_error) {
    die(json_encode(["message" => "Connection failed: " . $conn->connect_error]));
}

// Sanitize and validate the Id parameter
$Id = isset($_GET['Id']) ? intval($_GET['Id']) : null;
if (!$Id) {
    die(json_encode(["message" => "Invalid Id parameter"]));
}

// Query to fetch data
$sql = "SELECT `LoanAmount`, `BalAmount`, `PayAmount`, `ExpDate`, `Pay_days`, `Day_Charge`, `Code` 
        FROM `tblcusnewloandetail` 
        WHERE id = $Id AND States = 'A'";
$result = $conn->query($sql);

if (!$result) {
    die(json_encode(["message" => "Query failed: " . $conn->error]));
}

$leaders = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $leaders[] = [
            "LoanAmount" => $row["LoanAmount"],
            "BalAmount" => $row["BalAmount"],
            "PayAmount" => $row["PayAmount"],
            "ExpDate" => $row["ExpDate"],
            "Pay_days" => $row["Pay_days"],
            "Day_Charge" => $row["Day_Charge"],
            "Code" => $row["Code"],
        ];
    }
}

// Return JSON response
echo json_encode($leaders);

// Close connection
$conn->close();
?>
