<?php
header('Content-Type: application/json');
include 'db_config.php';

// Ensure database connection exists
if (!isset($conn)) {
    http_response_code(500);
    die(json_encode(["error" => true, "message" => "Database connection is not set."]));
}

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    die(json_encode(["error" => true, "message" => "Connection failed: " . $conn->connect_error]));
}

// Query to fetch data
$sql = "SELECT `Code`, `Customer`, `LoanAmount`, `BalAmount`, `PayAmount`, `id`, `Date`, `ExpDate`, `Days`, `Pay_days`, `Day_Charge` 
        FROM `tblcusnewloandetail` 
        WHERE States = 'A'";
$result = $conn->query($sql);

if (!$result) {
    http_response_code(500);
    die(json_encode(["error" => true, "message" => "Query failed: " . $conn->error]));
}

// Process results
$leaders = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $leaders[] = [
            "Code" => $row["Code"],
            "Customer" => $row["Customer"],
            "LoanAmount" => $row["LoanAmount"],
            "BalAmount" => $row["BalAmount"],
            "PayAmount" => $row["PayAmount"],
            "id" => $row["id"],
            "Date" => $row["Date"],
            "ExpDate" => $row["ExpDate"],
            "Days" => $row["Days"],
            "Pay_days" => $row["Pay_days"],
            "Day_Charge" => $row["Day_Charge"],
        ];
    }
}

// Return JSON response
echo json_encode($leaders, JSON_PRETTY_PRINT);

// Close connection
$conn->close();
?>
