<?php
header("Content-Type: application/json");
include 'db_config.php';

// Get input data
$data = json_decode(file_get_contents("php://input"), true);

// Extract data from JSON input
$Code = $data['Code']; //Recipt Code
$Pay_amu = $data['Pay_amu']; // Before the payment
$Pay_days = $data['Pay_days']; // Receipt-covered installment
$dloanCode = $data['dloanCode']; //Lona Code

// Begin transaction
$conn->begin_transaction();

try {
    if (empty($dloanCode)) {
        throw new Exception("Error: dloanCode is missing or invalid.");
    }
    if (empty($Pay_days)) {
        throw new Exception("Error: Pay_days is missing or invalid.");
    }

    // SQL query: Update `tblreceipts`
    $sql = "UPDATE `tblreceipts` 
            SET Status = 'C', `LastUpdate_Date` = CURRENT_DATE, `LastUpdate_time` = CURRENT_TIME 
            WHERE Code = ?";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("s", $Code);
    $stmt->execute();

    // Calculate new Pay_days
    $Pay_days = ($Pay_days - 1); // Add semicolon

    // SQL query: Update `tblcusnewloandetail`
    $sq2 = "UPDATE tblcusnewloandetail 
            SET BalAmount = BalAmount + ?, PayAmount = PayAmount - ?, Pay_days = ? 
            WHERE Code = ?";
    
    $stmt2 = $conn->prepare($sq2);
    if (!$stmt2) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt2->bind_param("ddds", $Pay_amu, $Pay_amu, $Pay_days, $dloanCode);
    $stmt2->execute();

    // Commit transaction
    $conn->commit();

    echo json_encode(["status" => "success", "message" => "Data processed successfully"]);
} catch (Exception $e) {
    // Rollback on error
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
// Close the connection
$conn->close();
?>
