<?php 
header("Content-Type: application/json");

include 'db_config.php'; 

// Check connection
if ($conn->connect_error) {
    die(json_encode(["message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ID = isset($_POST['id']) ? $_POST['id'] : null;
    $CuName = isset($_POST['LeaderName']) ? $_POST['LeaderName'] : null;
    $tel = isset($_POST['telno']) ? $_POST['telno'] : null;
    $add = isset($_POST['address']) ? $_POST['address'] : null;
    $add1 = isset($_POST['address1']) ? $_POST['address1'] : null;
    $add2 = isset($_POST['address2']) ? $_POST['address2'] : null;
    $type = isset($_POST['Type']) ? $_POST['Type'] : null;

    if ($ID && $CuName) {
        // Corrected bind_param to match the number of parameters
        $sql = "INSERT INTO `tblgroupleader`(`ID`, `Customer`, `Tel`, `address`, `address1`, `address2`, `Type`) VALUES (?, ?, ?, ?, ?, ?,?)";
        $stmt = $conn->prepare($sql);
        // Using "ssssss" for string parameters
        $stmt->bind_param("sssssss", $ID,$CuName, $tel, $add, $add1, $add2,$type );

        if ($stmt->execute()) {
            echo json_encode(["message" => "New record created successfully"]);
        } else {
            echo json_encode(["message" => "Error: " . $stmt->error]);
        }
    } else {
        echo json_encode(["message" => "Missing parameters" ]);
    }
}

$conn->close();
?>
