<?php 
header("Content-Type: application/json");

include 'db_config.php'; 

// Check connection
if ($conn->connect_error) {
    die(json_encode(["message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ID = isset($_POST['id']) ? $_POST['id'] : null;
    $CuName = isset($_POST['Name']) ? $_POST['Name'] : null;
    $tel = isset($_POST['telno']) ? $_POST['telno'] : null;
    $Group = isset($_POST['Group']) ? $_POST['Group'] : null;

    
    

    if ($ID && $CuName) {
        // Corrected bind_param to match the number of parameters
        $sql = "INSERT INTO `tblgroupmember`(`ID`, `Customer`, `Tel`, `GroupCode`) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);

        // Use appropriate type for ID if it's an integer
        $stmt->bind_param("ssss", $ID, $CuName, $tel, $Group);

        if ($stmt->execute()) {
            echo json_encode(["message" => "New record created successfully"]);
        } else {
            echo json_encode(["message" => "Error: " . $stmt->error, "code" => $stmt->errno]);
        }
    } else {
        echo json_encode(["message" => "Missing parameters"]);
    }
}

$conn->close();
?>
