<?php
header("Content-Type: application/json");

include 'db_config.php'; 

// Check connection
if ($conn->connect_error) {
    die(json_encode(["message" => "Connection failed: " . $conn->connect_error]));
}

$username = isset($_GET['Id']) ? $_GET['Id'] : null;
$password = isset($_GET['name']) ? $_GET['name'] : null;




// Handle GET requests
// Handle GET requests
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $users = []; // Initialize as an empty array

    if ($username && $password) {
        // Prepare the SQL statement
        $sql = "SELECT id, username, email FROM users WHERE username = ? AND password = ?";
        $stmt = $conn->prepare($sql);

        if (!$stmt) {
            die(json_encode(["message" => "SQL error: " . $conn->error]));
        }

        // Bind parameters
        $stmt->bind_param("ss", $username, $password); // Ensure the types match your DB schema
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $users[] = $row;
            }
        } else {
            error_log("No users found for Id: $username and Name:$password"); // Log when no user is found
        }
    } else {
        echo json_encode([]);
        exit; // Ensure the script ends here if no parameters are provided
    }
    
    // Return the users array (could be empty)
    echo json_encode($users);
}

// Handle POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	 
	  $email = isset($_POST['user']) ? $_POST['user'] : null;
	  $user = isset($_POST['email']) ? $_POST['email'] : null;
      $pass = isset($_POST['pass']) ? $_POST['pass'] : null;
    

    if ($pass && $user) {
        $sql = "INSERT INTO users (`username`, `email`, `password`) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $user,email,$pass); // Bind parameters (s for string)

        if ($stmt->execute()) {
            echo json_encode(["message" => "New record created successfully"]);
        } else {
            echo json_encode(["message" => "Error: " . $stmt->error]); // Use $stmt->error
        }
    } else {
        echo json_encode(["message" => "Missing parameters"]);
    }
}

$conn->close();
?>
